(function($) {
  $.fn.findAndHighlight = function(str, options){
    return this.each(function(){
      if(str == '') return;
      var text = $(this).text();
      
      var regexOpt = '';
      if(!options.caseSensitive){
        regexOpt += 'i';
      }
      if(!options.firstOnly){
        regexOpt += 'g';
      }
      
      var re = new RegExp("("+str+")", regexOpt);
      text = text.replace(re, "<span>$1</span>");
      
      $(this).html(text);
      $(this).find('span').css('backgroundColor', options.color);
    });
  };
  $.fn.resetHighlight = function(){
    return this.each(function(){
      var text = $(this).text();
      var re = new RegExp("</?span>","gi");
      text = text.replace(re, "");
      $(this).html(text);
    });
  };
})(jQuery);
